window.onload = function() 
{
	// --- Prüfen der eingaben im Formular ---
	document.getElementById("anmeldeformular").onsubmit = testeFormular;
	
	// --- Nachfrage ob Formular wirklich geleert weden soll ---
	document.getElementById("anmeldeformular").onreset = nachfrageLeeren;
	
	//--- Hilfe beim Ausfüllen der Formularfelder ---
	document.getElementsByName("nachname")[0].onfocus = function()
	{
		putStatus('&emsp;&emsp; Bitte geben Sie Ihren Nachnamen ein.');
	};
	document.getElementsByName("nachname")[0].onblur = function() 
	{
		leerenBildschirm();
	}
	document.getElementsByName("vorname")[0].onfocus = function()
	{
		putStatus('&emsp;&emsp; Bitte geben Sie Ihren Vornamen ein.');
	};
	document.getElementsByName("vorname")[0].onblur = function() 
	{
		leerenBildschirm();
	}
	document.getElementsByName("telefon")[0].onfocus = function()
	{
		putStatus('&emsp;&emsp; Bitte geben Sie nur Zahlen ein und - oder / .');
	};
	document.getElementsByName("telefon")[0].onblur = function() 
	{
		leerenBildschirm();
	};
	document.getElementsByName("plz")[0].onfocus = function() 
	{
		putStatus('&emsp;&emsp; Geben Sie in des Eingabefeld entweder max. 5 Zahlen ein oder <br> &emsp;&emsp; Sie nutzen bitte das Anschriftenfeld für Ihren postal code.');
	};
	document.getElementsByName("plz")[0].onblur = function() 
	{
		leerenBildschirm();
	};
	document.getElementsByName("anschrift")[0].onfocus = function() 
	{
		putStatus('&emsp;&emsp; Bitte geben Sie Straße, Hausnummer oder sonstige Angaben zur Wohnung ein.');
	};
	document.getElementsByName("anschrift")[0].onblur = function() 
	{
		leerenBildschirm();
	};
	document.getElementsByName("anschrift2")[0].onfocus = function() 
	{
		putStatus('&emsp;&emsp; Bitte geben Sie hier eine veränderte Lieferanschrift, Packstation oder Zweitwohnadresse an, <br> &emsp;&emsp; zu der wir gern Ihre Bestellung senden. ');
	};
	document.getElementsByName("anschrift")[0].onblur = function() 
	{
		leerenBildschirm();
	};
	document.getElementsByName("nutzer")[0].onfocus = function() 
	{
		putStatus('&emsp;&emsp; Bitte geben Sie sich einen Nutzernamen oder verwenden Sie einen angelgten Nutzer!');
	};
	document.getElementsByName("nutzer")[0].onblur = function() 
	{
		leerenBildschirm();
	};  
	document.getElementsByName("kennwort")[0].onfocus = function() 
	{
		putStatus('&emsp;&emsp; Bitte geben Sie das zugeschickte Kennwort ein!');
	};
	document.getElementsByName("kennwort")[0].onblur = function() 
	{
		leerenBildschirm();
	};  
};

function datenAusgabe()
{	
	leerenBildschirm(); 			// um Bildschirm aufzuräumen
	var anrede = "" ;
	var vorname = "" ;
	var nachname = "" ;
	var titel = "" ;
	var telefon = "" ;
	var plz = "" ;
	var ort = "" ;
	var anschrift = "" ;
	var anschrift2 = "" ;
	var land = "" ;
	var mail = "" ;
	var nutzer = "" ;
	var kennwort = "" ;
	var bemerkung = "" ;

	 anrede = document.anmeldeformular.anrede.value ;
	 vorname = document.anmeldeformular.vorname.value ;
	 nachname = document.anmeldeformular.nachname.value ;
	 titel = document.anmeldeformular.titel.value ;
	 telefon = document.anmeldeformular.telefon.value ;
	 plz = document.anmeldeformular.plz.value ;
	 ort = document.anmeldeformular.ort.value ;
	 anschrift = document.anmeldeformular.anschrift.value ;
	 anschrift2 = document.anmeldeformular.anschrift2.value ;
	 land = document.anmeldeformular.land.value ;
	 mail = document.anmeldeformular.mail.value ;
	 nutzer = document.anmeldeformular.nutzer.value ;
	 kennwort = document.anmeldeformular.kennwort.value ;
	 bemerkung = document.anmeldeformular.bemerkung.value ;
	
	// --- Ausgabe der Feldinhalte --- 
	document.getElementById("personenangaben").innerHTML = "<ul><li>Hier sind Ihre Eingaben: &emsp;&emsp; </li> " + anrede + " &emsp; " + vorname + " &emsp; " + nachname + " &emsp; " + titel 
	 + "  <br><br><li> Adress- und Kontaktdaten: </li> Telefon: &ensp; " + telefon + " &emsp; Anschrift: &ensp; " + plz + " &emsp; " + ort + " &emsp; " + anschrift + " &emsp; "  + anschrift2 + " &emsp; " + land 
	 + " &emsp; Mailadresse: &ensp; " + mail + " <br><br><li> Zugangsdaten: &emsp;&emsp;</li> " + nutzer + " &emsp; " + kennwort + " <br><br><li> Ihre Bemerkung:  &emsp;&emsp;</li> " + bemerkung + "</ul>";
}
			

function testeZeichen(testString, erlaubteZeichen) {
	var allezeichenok = true;
	for (var i = 0; i < testString.length; i++)
		if (erlaubteZeichen.indexOf(testString.charAt(i)) == -1) {
			allezeichenok = false;
			break;
		}
	return allezeichenok;
}
// regulärere Ausdruck, prüft ob min. 2 Zeichen vor @ (/^[\w\.\-]{2,}\@), Top-LevelDomains am Ende, wie .de, dürfen nur 2-4 Buchstaben enthalten (\.[a-z]{2,4}$)
function testeMailadresse(testString) {
	var suche = /^[\w\.\-]{2,}\@[äöüa-z0-9\-\.]{1,}\.[a-z]{2,4}$/i;
	return suche.test(testString);
}
// -- Prüfung der Eingaben, with spart die volle Benennung document....
function testeFormular() 
{
	leerenBildschirm(); 			// um Bildschirm aufzuräumen
	var fehlermeldung = "";
	with (document.getElementById("anmeldeformular"))  // with spart Schreibarbeit
	{
		if (nachname.value == "") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie Ihren Nachname ein! <br />";
		}
		if (vorname.value == "") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie Ihren Vornamen ein! <br />";
		}
		if (!testeZeichen(plz.value, "1234567890")) 
		{
			fehlermeldung += "&emsp;&emsp; Geben Sie f&uuml;r die Postleitzahl bitte nur Zahlen ein! <br />";
		}
		if (plz.value.length > 5) 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie f&uuml;nf Zahlen f&uuml;r die Postleitzahl ein! <br />";
		}
		if (ort.value == "") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie Ihren Wohnort an! <br />";
		}
		if (anschrift.value == "") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie Ihre Anschrift an!<br />";
		}
		if (land.value == "") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie Ihr Heimatland an!<br />";
		}
		if (nutzer.value == "") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte verwenden Sie einen Nutzernamen f&uuml;r den Besuch unserer Seite!<br />";
		}
		if (kennwort.value === "") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie ein Kennwort ein!<br />";
		}  	
		if (kennwort.value != "geheim") 
		{
			fehlermeldung += "&emsp;&emsp; Bitte geben Sie das zugeschickte Kennwort ein!<br />";
		}  	
	// Telefon keine Pflichtangabe deshalb nur Test, ob nur Zahlen eingegeben wurden
	
	// --- Spezielle Eingaben auf Gültigkeit testen	---
		if (!testeZeichen(telefon.value, "1234567890-/")) 
		{
			fehlermeldung += "&emsp;&emsp; Geben Sie f&uuml;r die Telefonnummer bitte nur Zahlen ein!<br />";
		}
		if (!testeMailadresse(mail.value)) 
		{
			fehlermeldung += "&emsp;&emsp; Die E-Mail-Adresse ist nicht korrekt!<br />";
		}
		
		// Inhalt Cookie 
		nutzerdaten = anrede + " " + titel + " " + vorname + " " + nachname +  " Ihr Nutzername ist: " + nutzer ;
	}
	
	if (fehlermeldung != "") 
	{
		putStatus(fehlermeldung);
		return false;
	} 
	else 
	{	
		//setCookie("Nutzer", nutzerdaten, 1 ) ; 
		setzeCookie() ;
		return confirm("M&ouml;chten Sie die Anmeldung jetzt senden?");
	}
}

function nachfrageLeeren(myform) 
{
	return confirm("Wollen Sie das Formular und alle Einträge wirklich zur&uuml;cksetzen?");
}

// --- Meldungen zur Eingabeprüfung im Formular anzeigen ---
function putStatus(mytext) 
{
	document.getElementById('status').innerHTML = mytext;
}

// --- Meldungen und Datenausgaben auf dem Formular entfernen ---
function leerenBildschirm() 
{
	document.getElementById('status').innerHTML = '';
	document.getElementById('personenangaben').innerHTML = '';
	document.getElementById('meldung').innerHTML = '';
	
}

function setzeCookie()
{
	var nutzerdaten = "" ;	
	document.cookie = "sitzungsdaten" ;
	
	// Verfallsdatum festlegen
	var datum = new Date();
	datum.setMinutes( datum.getMinutes() + 60 )
	
	// Formulardaten für Cookie übernehmen
	anrede = document.anmeldeformular.anrede.value ;
	vorname = document.anmeldeformular.vorname.value ;
	nachname = document.anmeldeformular.nachname.value ;
	nutzer = document.anmeldeformular.nutzer.value ;
	
	nutzerdaten = anrede + " " + titel + " " + vorname + " " + nachname +  " Ihr Nutzername ist: " + nutzer ;

	var nutzer = "Nutzer=nutzerdaten; path=/; expires=" + datum.toGMTString() ;   // expires --> Haltbarkeitsdatum direkt angeben
					
	//document.write( nutzer );		// für Testausgabe								//

	document.cookie = nutzer ;

}

function setCookie(cname,cvalue,exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires=" + d.toGMTString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
	}
	
	